---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：118-スクリプト操作（Script Operations）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **Pythonカーネル実装の詳細**：Python側のレジストリとブリッジ実装は未確認
  2. **GILの影響の詳細**：一般的知識に基づく記述

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/script_ops.cc` 全体（49行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 118行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PyFuncはステートフルOpとして登録される | E-01（27行目のSetIsStateful） | ○ |
| C-02 | PyFuncStatelessはSetIsStatefulが呼ばれていない | E-01（30-36行目） | ○ |
| C-03 | EagerPyFuncはis_async属性を持つ | E-01（43行目） | ○ |
| C-04 | EagerPyFuncのis_asyncデフォルトはfalse | E-01（43行目`is_async: bool=false`） | ○ |
| C-05 | 全Opの入力はTin型のリスト | E-01（22, 31, 39行目） | ○ |
| C-06 | 全Opの出力はTout型のリスト | E-01（23, 32, 40行目） | ○ |
| C-07 | token属性で関数を識別する | E-01（24, 33, 41行目） | ○ |
| C-08 | Tin/Toutのリストサイズは>= 0 | E-01（25-26, 34-35, 42-44行目） | ○ |
| C-09 | 全Opの出力形状はUnknownShape | E-01（28, 36, 46行目のSetShapeFn） | ○ |
| C-10 | 3つのOp（PyFunc, PyFuncStateless, EagerPyFunc）が存在 | E-01 | ○ |
| C-11 | 機能説明がCSVの記載と整合 | E-02 | ○ |
| C-12 | Python側の関数レジストリとブリッジ実装の詳細 | **根拠なし** | △ |
| C-13 | GILの影響によるパフォーマンス制限 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: Python側のカーネル実装は今回のスコープでは参照していない
  - 候補：tensorflow/python/lib/core/py_func.py / tensorflow/python/eager/pywrap_tfe_src.cc
- C-13: GILの影響は一般的なPython知識に基づく
  - 候補：CPython GILドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Op定義は簡潔であり、3つのOpの差異は明確

## 6) レビュアーチェックリスト（最小）
- [ ] 3つのOpの差異（ステートフル性、is_async）が正確に記述されているか確認
- [ ] Python側のレジストリ実装との整合性を確認
- [ ] パフォーマンス制限の記述が妥当か確認
